#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//optical Circuit Deconstruction EMod01.fsh   by   ollj  
//https://www.shadertoy.com/view/MltyR7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


//deconstructed down to
//volume marching of planes
//which is noised and log-glowing to hide low precision on its animated fractal texture


//self: https://www.shadertoy.com/view/MlfczH
//Optical-Circuit optical circuit scene 1 deconstruction a

/*
the [optical circuit demo] video source code once appeared on glslsandbox.com

www.pouet.net/prod.php?which=65125
https://www.youtube.com/watch?v=ISkIB4w6v6I

It is fractal code golf overkill in [0..6] scenes.
This is a deconstruction of scene 1. ,not the whole demo.
Un-used functions(only used in other scenes)are removed;
scene-specific branches are set to 1,or removed 
...(multiplying by *0. or adding -0 iterations)
... all changes are annotated.

This may run slightly faster due to removing all schene-specific branching
Most of that modifies iteration count(between scenes,which are static per shader)
The [smart re-use of schene specific branches and modifiers] is what makes this a 4k demo.
... at a cost of running slightly slower,by summing up scene-modifiers.

most recent approach in summer 2018,removed globals and idenfified a lot of functions into subroutines.
the "hashes" are a bit unusual,overly specific but fine.
//this is now very sorted and demystified.
//it sure has an awesomely extended volume marcher for glow and accumulators for it
and thats glow-marching
*/

#define tim (iTime+timeOffset)

#define iterO 4
#define iterVolume 32

//#define scene 1
#define timeOffset 115.984024

#define dd(a)dot(a,a)
#define v0 float
#define v1 vec2
#define v2 vec3
#define v3 vec4
#define fra(u)(u-.5*iResolution.xy)*ViewZoom/iResolution.y
v0 mav(v1 a){return max(a.y,a.x);}
v0 mav(v2 a){return max(a.z,mav(a.xy));}
v0 mav(v3 a){return max(mav(a.zw),mav(a.xy));}
#define miv(a)-mav(-a)
float vsum(vec3 a){return dot(a,vec3(1));}//dot()is generally faster on a gpu than 2add()
 //return a.x+a.y+a.z;}

const float pi=acos(-1.);//3.14
const float t0=sqrt(.5);//0.707

#define tswap h=j;j=k;k=l

//return a,rotated by b,originally called F()
vec3 rot(vec3 a,float b){float c=sin(b),d=cos(b);return mat3(d,-c,0,c,d,0,0,0,1)*a;}

//fractal glowing planes
vec3 Glowplanes(vec3 a,float b
){a=fract(a*.2)*2.-1.
 ;a.z=b
 ;float c=50.//brightness modifier
 ;for(int i=0;i<5;++i//iteration count is scene specific
 ){float d=clamp(dd(a),.05,.65);
  ;c*=d;
  ;a=abs(a)/d-1.31;
  ;a.xy=a.xy*mat2(1,1,-1,1)*t0
 ;}return a*c;}
 
 //i thought this id some 4d magic,but it is barely 3d. 
 //its core hash is 2d,used to move planes endlessly
 //and one extension in 3d of it exists,so its barely 3d.

//sub of W and I(both aren ot in scene1)
vec3 vV(float a,vec3 b,float c,float V){a*=c;return 1./((1.+2.*b/a+b*b/(a*a))*c+.0001);}
//only used twice in mainImage,a and b and c are the same both times.
vec3 wW(vec3 a,float b,float c,float d,float V
){vec3 e=(vV(.01,abs(a),d,V)*2.+vV(.05,vec3(length(a.yz),length(a.zx),length(a.xy)),d,V)*5.)
  *(sin(tim*vec3(2.1,1.3,1.7)+b*10.)+1.)
 ;return(e*7.+e.yzx*1.5+e.zxy*1.5)*max(1.-c*200./d,0.)/d*float(100-30);}//is scene specific


void shuffle(inout vec4 h,inout vec4 j,inout vec4 k,inout vec4 l,int m){
 int a=m;for(int i=0;i<4;++i)if(a<4){tswap;++a;};}
//h,j,j,l are accumulators witthing raymarching,used for "noisy fog"

vec3 IterVol(vec4 h,vec4 j,vec4 k,vec4 l,vec3 g,float D,int m
){shuffle(h,j,k,l,m);
 ;float o=1.,p=.0,t=.0,q=D*.1+.9,W,V
 ,n=length(j.xyz-h.xyz)
 ;vec3 f=normalize(j.xyz-h.xyz),e=h.xyz,c=vec3(1),b=vec3(0)
 ;for(int i=0;i<iterVolume;++i
){if(t>n
 ){if(m<3)break
   ;tswap
   ;e=h.xyz;f=normalize(j.xyz-h.xyz);n=length(j.xyz-h.xyz)//j and h can have changed due to tswap()
   ;--m
   ;t=0.
   ;if(n<.0001)break
   ;float r=fract(h.w)
   ;o=h.w-r
   ;p=(floor(j.w)-o)/n
   ;c*=mix(vec3(.17,.15,.12),vec3(1),r);}
  ;g=e+f*t
  ;//next 5 lines are scene specific
  //;g-=vec3(0,0,vec2(sign(fract(g.z)-.5)))*u
  ;float v=sin(tim*.05+g.z)*.5
  ;float u=abs(fract(g.z)-.5)//this line 100% absorbs U(),for scene1
  ;float w=u
  ;w*=(q+.0001/iResolution.y)//w is low precision due to volume marching, we hide this in noise
  ;vec3 x=Glowplanes(g,v)
  ;b+=(wW(x,v,u,o+p*t,V)+wW(x,v,u,o+p*t+50.,V))*c*w
  ;c*=pow(.7,w)
  ;t+=w;}
 ;return b;}


void rm(inout vec4 h,inout vec4 j,inout vec4 k,inout vec4 l,inout vec3 g,vec3 f,inout int m,float D){
 ;f=normalize(f)//for reflection
 ;vec3 e=g
 ;vec3 s=vec3(1,-1,-1)*.0005 //epsilon
 ;float t=0.,o=1.,p=1.,q=D*.01+.99,n
 ;t=100.//t set to zFar
 ;g=e+f*t
 ;if(m<4){tswap;l=vec4(g,o+t*p);++m;}
 ;}

vec3 cam(vec3 c,vec3 b,vec2 glVertex){
 ;vec3 ee=normalize(vec3(sin(vec2(.53,.47)*tim)*4.+sin(vec2(.91,1.1)*tim)*2.+sin(vec2(2.3,1.7)* tim),200))
 ;vec3 ff=normalize(cross(ee,vec3(sin(tim),50,0)))
 ;return mat3(c,cross(c,b),b)*(ff*glVertex.x*1.78+cross(ff,ee)*glVertex.y+ee*1.4);}

vec4 in2d(vec2 Uuu){
 ;float mm=iMouse.y/iResolution.y-.5//scaled to a reaosnable period.
 ;mm*=3.//can increment ocraves.
 ;mm=abs(fract(mm)*2.-1.);//seesaw to triangle
 //;mm=cos(mm*pi)//seesaw to cos
 ;float aa=iMouse.y/iResolution.y
 ;vec3 c=Glowplanes(vec3(Uuu/75.,0),mm)
 ;c=abs(c)
 ;c=smoothstep(vec3(.3),vec3(-.3),c)
 ;c=pow(c,vec3(0.61))
 ;return vec4(c,1)
 ;}

vec4 in3d(vec2 Uuu){
 ;vec3 a=normalize(sin(tim*.001*vec3(21,11,17)))*20.1//basic orbit feeds into many things
 ;vec3 b=normalize(sin(tim*.001*vec3(26,106,62))-a*.05)//feeds into looking direction
 ;vec3 c=normalize(cross(b,sin(tim*.001*vec3(31,17,29))))//feeds into looking direction
 ;c=cam(c,b,Uuu.xy/iResolution.xy*2.-1.)//looking direction
 ;float D=fract(sin(vsum(c)*99.317*pi)*85.081*pi)//camera path
 ;vec4 l=vec4(a,1),k=l*.0,j=k,h=j;int m=1//inout to shuffle to scatter glowing fog
 ;rm(h,j,k,l,a,c,m,D)//a very extended raymarching function
 ;return vec4(pow(IterVol(h,j,k,l,a,D,m),vec3(.45)),1)
 ;}

//cosine interpolation is a smoothstep() with better derivatives. //not good for a==0.
#define sss(a) (1.-cos(sat(a)*pi))
//a more worksave version of sss()
#define ss2(a,b) mix(sss(a)*.5,step(a,0.),step(b,0.)+step(0.,b)-1.)
#define sat(a) clamp(a,0.,1.)
#define fragColor O
#define fragCoord Uuu

//void mainImage(out vec4 O,in vec2 Uuu
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

 ;float b=iMouse.x/iResolution.x
 ;float s=1./abs(b*2.-1.)
 ;vec2 a=Uuu/iResolution.xy*s-(s-2.)*.5-.5
 ;float c=ss2(a.x,b)
 //is much simpler is i do the cosstep seperately
 ;if(c==1.)fragColor=in2d(Uuu)
 ;else if(c==0.)fragColor=in3d(Uuu)
 ;else fragColor=mix(in3d(Uuu),in2d(Uuu),c)
/**/

 ;float g=Uuu.y/iResolution.y
 ;fragColor+=.2*g*vec4(vec3(step(abs(c-g),.01)),1)//cosine interpolation of the "circle of cinfusion" interpolation area.
 ;O+=.2*g*step(abs(abs(Uuu.x/iResolution.x-.5)-abs(iMouse.x/iResolution.x*2.-1.)*.5) ,.005)//bounding volume bars
 /**/
 ;   

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

